



<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, shrink-to-fit=no"
    />
    <meta
      name="description"
      content="Start your development with a Dashboard for Bootstrap 4."
    />
    <meta name="author" content="Creative Tim" />
    <title>Auth</title>

    <!-- Canonical SEO -->
    <link
      rel="canonical"
      href="https://www.creative-tim.com/product/impact-design-system"
    />

    <!--  Social tags      -->
    <meta
      name="keywords"
      content="impact design system, design system, login, form, table, tables, calendar, card, cards, navbar, modal, icons, icons, map, chat, carousel, menu, datepicker, gallery, slider, date, sidebar, social, dropdown, search, tab, nav, footer, date picker, forms, tabs, time, button, select, input, timeline, cart, car, fullcalendar, about us, invoice, account, chat, log in, blog, profile, portfolio, landing page, ecommerce, shop, landing, register, app, contact, one page, sign up, signup, store, bootstrap 4, bootstrap4, dashboard, bootstrap 4 dashboard, bootstrap 4 design, bootstrap 4 system, bootstrap 4, bootstrap 4 uit kit, bootstrap 4 kit, impact, impact ui kit, creative tim, html kit, html css template, web template, bootstrap, bootstrap 4, css3 template, frontend, responsive bootstrap template, bootstrap ui kit, responsive ui kit, impact dashboard"
    />
    <meta
      name="description"
      content="Kick-Start Your Development With An Awesome Design System carefully designed for your online business showcase. It comes as a complete solution, with front pages and dashboard pages included."
    />

    <link
      rel="stylesheet"
      href="dashboard/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css"
      type="text/css"
    />

    <!-- Add this inside <head> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">


    <style>
      @import url("https://fonts.googleapis.com/css?family=Montserrat:400,800");

      * {
        box-sizing: border-box;
      }

      body {
        background: #ffffff;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        font-family: "Montserrat", sans-serif;
        height: 100vh;
        margin: -20px 0 50px;
      }

      h1 {
        font-weight: bold;
        margin: 0;
      }

      h2 {
        text-align: center;
      }

      p {
        font-size: 14px;
        font-weight: 100;
        line-height: 20px;
        letter-spacing: 0.5px;
        margin: 20px 0 30px;
      }

      span {
        font-size: 12px;
      }

      a {
        color: black;
        font-size: 14px;
        text-decoration: none;
        margin: 15px 0;
      }

      button {
        border-radius: 20px;
        border: 1px solid black;
        background-color: #c1ff72;
        color: black;
        font-size: 12px;
        font-weight: bold;
        padding: 12px 45px;
        letter-spacing: 1px;
        text-transform: uppercase;
        transition: transform 80ms ease-in;
      }

      button:active {
        transform: scale(0.95);
      }

      button:focus {
        outline: none;
      }

      button.ghost {
        background-color: transparent;
        border-color: black;
      }

      form {
        background-color: #ffffff;
        display: flex;
        padding: 0 50px;
        height: 100%;
        text-align: center;
        flex-direction: column;
        justify-content: center;
      }

      .container {
        /* background-color: #fff;
        border-radius: 10px;
        box-shadow: 0 14px 28px rgba(0, 0, 0, 0.25),
          0 10px 10px rgba(0, 0, 0, 0.22);
        overflow: hidden;
        width: 880px; */
        max-width: 100%;
        min-height: 526px;
      }

      .form-container {
        position: absolute;
        top: 0;
        height: 100%;
        transition: all 0.6s ease-in-out;
      }

      .sign-in-container {
        left: 0;
        width: 50%;
        z-index: 2;
      }

      .container.right-panel-active .sign-in-container {
        transform: translateX(100%);
      }

      .sign-up-container {
        left: 0;
        width: 50%;
        opacity: 0;
        z-index: 1;
      }

      .container.right-panel-active .sign-up-container {
        transform: translateX(100%);
        opacity: 1;
        z-index: 5;
        animation: show 0.6s;
      }

      @keyframes show {
        0%,
        49.99% {
          opacity: 0;
          z-index: 1;
        }

        50%,
        100% {
          opacity: 1;
          z-index: 5;
        }
      }

      .overlay-container {
        position: absolute;
        top: 0;
        left: 50%;
        width: 50%;
        height: 100%;
        overflow: hidden;
        transition: transform 0.6s ease-in-out;
        z-index: 100;
      }

      .container.right-panel-active .overlay-container {
        transform: translateX(-100%);
      }

      .overlay {
        background: #c1ff72;
        background: linear-gradient(87deg, #c1ff72 0, #c1ff72 100%) !important;
        background-repeat: no-repeat;
        background-size: cover;
        background-position: 0 0;
        color: black;
        position: relative;
        left: -100%;
        height: 100%;
        width: 200%;
        transform: translateX(0);
        transition: transform 0.6s ease-in-out;
      }

      .container.right-panel-active .overlay {
        transform: translateX(50%);
      }

      .overlay-panel {
        position: absolute;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        padding: 0 40px;
        text-align: center;
        top: 0;
        height: 100%;
        width: 50%;
        transform: translateX(0);
        transition: transform 0.6s ease-in-out;
      }

      .overlay-left {
        transform: translateX(-20%);
      }

      .container.right-panel-active .overlay-left {
        transform: translateX(0);
      }

      .overlay-right {
        right: 0;
        transform: translateX(0);
      }

      .container.right-panel-active .overlay-right {
        transform: translateX(20%);
      }

      .social-container {
        margin: 20px 0;
      }

      .social-container a {
        border: 1px solid #dddddd;
        border-radius: 50%;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        margin: 0 5px;
        height: 40px;
        width: 40px;
      }

      footer {
        background-color: black;
        color: #fff;
        font-size: 14px;
        bottom: 0;
        position: fixed;
        left: 0;
        right: 0;
        text-align: center;
        z-index: 999;
      }

      footer p {
        margin: 10px 0;
      }

      footer i {
        color: red;
      }

      footer a {
        color: lime;
        text-decoration: none;
      }

      label {
        display: inline-block;
        margin-bottom: 0.5rem;
      }

      /* form starting stylings ------------------------------- */
      .group {
        position: relative;
        margin-bottom: 1em;
      }

      input {
        width: 100%;
        font-size: 16px;
        padding: 12px 16px 14px 16px;
        border: 1px solid black;
        border-radius: 24px;
        transition: opacity 150ms cubic-bezier(0.4, 0, 0.2, 1);
        margin-bottom: 15px;
      }

      input:focus {
        outline: none;
        border: 1px solid black;
        caret-color: #6200ee;
        caret-color: var(--mdc-theme-primary, #6200ee);
        box-sizing: border-box;
        transition: opacity 150ms cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: inset 0 0 1px #00a2db, inset 0 0 1px #00a2db,
          inset 0 0 1px #00a2db;
      }

      /* LABEL ======================================= */
      label {
        color: black;
        font-size: 16px;
        font-weight: normal;
        position: absolute;
        pointer-events: none;
        left: 32px;
        top: 14px;
        transition: 0.3s ease all;
        -moz-transition: 0.3s ease all;
        -webkit-transition: 0.3s ease all;
      }

      /* active state */
        input:focus ~ label,
      input:valid ~ label,
      input:active ~ label {
        top: -10px;
        left: 14px;
        font-size: 12px;
        padding: 4px;
        color: black;
        background-color: #ffffff;
      }

      .forgot-pass, .new-pass, .pwd-reset-successful{
          z-index: 99999;
          background-color: white;
          padding: 23px;
          text-align: center;
          height: 100%;
          display: flex;
          animation: slideIn 0.5s ease-in-out forwards;
          display: none;
          flex-direction: column;
          justify-content: center;
      }


      .otp-container {
        display: flex;
        justify-content: center;
        gap: 10px;
      }
    .otp-input, .otp-input-registration {
      width: 50px;
      height: 50px;
      text-align: center;
      font-size: 26px;
      border: 2px solid #052862;
      border-radius: 8px;
    }
    #successDiv {
      margin-top: 30px;
      padding: 20px;
      background-color: #e0ffe0;
      color: #006400;
      border: 2px solid #00c400;
      border-radius: 10px;
      width: 300px;
      margin-left: auto;
      margin-right: auto;
      display: none;
      animation: slideIn 0.5s ease-in-out forwards;
    }
    @keyframes slideIn {
      from {
        transform: translateY(20px);
        opacity: 0;
      }
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .forgot-pass-btn{
      margin: 9px;
      cursor: pointer;
    }

    #passwordResetStrengthVerification, #signupPasswordResetStrengthVerification{
      text-align: left !important;
      margin-bottom: 27px;
    }

    #togglePassword, #toggleMainPassword{
      position: absolute;
      right: 20px;
      top: 40%;
      transform: translateY(-50%);
      cursor: pointer;
      font-size: 17px;
    }

    #toggleRegisterPassword {
      position: absolute;
      right: 20px;
      top: 24px;
      transform: translateY(-50%);
      cursor: pointer;
      font-size: 17px;
    }

    #resetPasswordBtn:disabled {
      background-color: #c8c8c8;
      color: black;
      cursor: not-allowed;
      border: 1px solid white;
    }

    #resetPasswordBtn:enabled {
      color: black;
      cursor: pointer;
    }

    .country_code{
      display: flex;
      align-items: center;
      gap: 5px;
      position: absolute;
      margin-top: -51px;
      margin-left: 10px;
      font-size: 21px;
    }

    #textFieldPhone{
      padding: 12px 16px 14px 70px !important;
    }

    .phone_number_place_holder{
      position: absolute;
      top: -10px;
      left: 14px;
      font-size: 12px;
      padding: 4px;
      color: black;
      background-color: #ffffff;
    }

    #username_pass, #phoneNumberPass{
      color: green;
      position: absolute;
      font-size: 18px;
      top: 12px;
      right: 17px;
    }

    #signupInstead, .signupExtension{
      display: none;
    }

    .signinExtension{
      display: none;
    }

    @media (max-width: 480px) {
      .sign-in-container {
        left: 0;
        width: 100%;
      }
      button.ghost{
        border: 2px solid black;
      }
      .overlay-container{
        display: none;
      }
      #signupInstead{
        display: block;
        color: black;
        border: 1px solid black;
        background: #00800000;
      }
      .signupExtension{
        margin-top: 100px;
        display: flex;
        flex-direction: column;
        display: flex;
      }
      .sign-up-container {
        left: -100%;
        width: 100%;
        opacity: 0;
        z-index: 1;
      }
      form{
        padding: 0px 25px;
        z-index: 99;
        position: absolute;
        background-color: #ffffff00;
        width: 100%;
      }
      .overlay-panel {
        height: 100%;
        width: 100%;
        transform: translateX(0);
        transition: transform 0.6s ease-in-out;
        margin-top: 300px;
      }
      #signupContainer{
        margin-top: -140px;
      }

      .signinExtension{
        display: flex;
      }

      #signinInstead{
        color:black ;
      }
    }
    </style>
  </head>

  <body>
    <!-- <h2>Welcome to payvia</h2> -->
    <div class="container" id="container">
      <div class="form-container sign-up-container">
        <form id="signupContainer">
          <div class="logo">
            <img src="dashboard/assets/img/rise-logo.png" alt="" style="width: 200px;">
          </div>
          <h1>Create Account</h1>
          <div class="social-container">
            <a href="#" class="social"><i class="fab fa-facebook-f"></i></a>
            <a href="#" class="social"><i class="fab fa-google-plus-g"></i></a>
            <a href="#" class="social"><i class="fab fa-linkedin-in"></i></a>
          </div>
          <br>
          <div class="group mt-5" style="margin-bottom: 0px">
            <input type="test" id="name" required />
            <label for="">Name</label>
          </div>
          <div class="group mt-5" style="margin-bottom: 7px">
            <input type="test" id="usersNameRegister" required />
            <label for="">@user_name</label>
            <span id="username_pass" style="display: none;"><i class="fa-regular fa-circle-check"></i></span>
            <small id="usernameStatus" style="color: red; font-size: 12px;"></small>
          </div>
          <div class="group mt-5" style="margin-bottom: 7px">
            <input type="text" id="textFieldPhone" maxlength="9" placeholder="6xxx xxx xxx" required />
            <span class="phone_number_place_holder">Phone number</span>
            <span id="phoneNumberPass" style="display: none;"><i class="fa-regular fa-circle-check"></i></span>
            <span class="country_code">
              🇨🇲 <span>+237</span>
            </span>
            <small id="phoneError" style="color: red; font-size: 12px;"></small>
            
          </div>
          <div class="group mt-5" style="margin-bottom: 0px">
            <input type="password" id="registerPassword" required />
            <label for="">Password</label>
            <span id="toggleRegisterPassword">
              <i class="fa-regular fa-eye" id="showRegisterPass"></i>
              <i class="fa-solid fa-eye-slash" id="hideRegisterPass" style="display: none;"></i>
            </span>
            <div id="signupPasswordResetStrengthVerification" style="display: none;"></div>
          </div>
          <button id="registerBtn" disabled>Sign Up</button>
        </form>
        <div class="signinExtension">
          <div class="overlay-panel overlay-left">
            <div class="cont">
              <h1>Welcome Back!</h1>
              <p>
                To keep connected with us please login with your personal info
              </p>
            </div>
            <button class="ghost" id="signinInstead">Sign In</button>
          </div>
        </div>
        <!-- Signup password starts here -->
        <div class="forgot-pass" id="phoneVerification">
          
          <h1>OTP Verification</h1>
          <p>Please enter the Verification code sent to your phone number 653 766 939</p>
          <div class="otp-container">
            <input type="text" maxlength="1" class="otp-input-registration" />
            <input type="text" maxlength="1" class="otp-input-registration" />
            <input type="text" maxlength="1" class="otp-input-registration" />
            <input type="text" maxlength="1" class="otp-input-registration" />
            <input type="text" maxlength="1" class="otp-input-registration" />
            <input type="text" maxlength="1" class="otp-input-registration" />
          </div>
          <p>Did not receive? Resend in <span id="secLeftToSendVerificationOTP">59</span> sec</p>
          <button id="resendVerificationOTP">Resend</button>
        </div>
      </div>
      <div class="form-container sign-in-container" id="sign-in-container">
        <form action="#"  id="signInContainer">
          <div class="logo">
            <img src="dashboard/assets/img/rise-logo.png" alt="" style="width: 200px;">
          </div>
          <h1>Signin</h1>
          <div class="social-container">
            <a href="#" class="social"><i class="fab fa-facebook-f"></i></a>
            <a href="#" class="social"><i class="fab fa-google-plus-g"></i></a>
            <a href="#" class="social"><i class="fab fa-linkedin-in"></i></a>
          </div>
          <br>
          <div class="group mt-5" style="margin-bottom: 0px">
            <input type="test" id="userName"  />
            <label for="">@user_name</label>
          </div>
          <div class="group mt-5" style="margin-bottom: 0px">
            <input type="password" id="mainPassword"  />
            <label for="">Password</label>
            <span id="toggleMainPassword">
              <i class="fa-regular fa-eye" id="showPass"></i>
              <i class="fa-solid fa-eye-slash" id="hidePass" style="display: none;"></i>
            </span>
          </div>
          <span class="forgot-pass-btn" onclick="forgotPassword()">Forgot your password?</span>
          <button>Sign In</button>
          
          <div class="signupExtension">
            <div class="cont">
              <h1>Hello, Friend!</h1>
              <p>Enter your personal details and start your journey with us</p>
            </div>
            <button id="signupInstead">Signup</button>
          </div>
        </form>
        <!-- forgot password starts here -->
        <div class="forgot-pass" id="forgotPassDiv">
          
          <h1>OTP Verification</h1>
          <p>Please enter the Verification code sent to this number 65* *** *39</p>
          <div class="otp-container">
            <input type="text" maxlength="1" class="otp-input" />
            <input type="text" maxlength="1" class="otp-input" />
            <input type="text" maxlength="1" class="otp-input" />
            <input type="text" maxlength="1" class="otp-input" />
            <input type="text" maxlength="1" class="otp-input" />
            <input type="text" maxlength="1" class="otp-input" />
          </div>
          <p>Did not receive? Resend in <span id="secLeftToSendOTP">59</span> sec</p>
          <button id="resendOTP">Resend</button>
        </div>

        <!-- ADD NEW PASSWORD STARTS HERE-->
        <div class="new-pass" id="newPass">
          <h1>Reset Password</h1>
          <p>Dear Sama, you can reset your password here</p>
          <div class="reset-container">
            <div class="group mt-5" style="margin-bottom: 0px">
              <input type="password" id="newPasswordInput" required />
              <label for="">New Password</label>
              <span id="togglePassword">
                <i class="fa-regular fa-eye" id="showIcon"></i>
                <i class="fa-solid fa-eye-slash" id="hideIcon" style="display: none;"></i>
              </span>
            </div>
          </div>
          <div id="passwordResetStrengthVerification"></div>
          <button id="resetPasswordBtn" disabled>Reset Password</button>
        </div>

        <div class="pwd-reset-successful" id="resetSuccessfull">
          <h1>Reset Successful</h1>
          <img src="dashboard/assets/img/success.gif" alt="" style="width: 200px; height: 200px;">
          <p>Your password was successfully resetted. You can log into your account</p>
          <button id="login" onclick="loginBtn()">login</button>
        </div>
        <!-- ADD NEW PASSWORD ENDS HERE-->

         <!-- forgot password ends here -->
      </div>
      <div class="overlay-container">
        <div class="overlay">
          <div class="overlay-panel overlay-left">
            <div class="cont">
              <h1>Welcome Back!</h1>
              <p>
                To keep connected with us please login with your personal info
              </p>
            </div>
            <button class="ghost" id="signIn">Sign In</button>
          </div>
          <div class="overlay-panel overlay-right">
            <div class="cont">
              <h1>Hello, Friend!</h1>
              <p>Enter your personal details and start your journey with us</p>
            </div>
            <button class="ghost" id="signUp">Sign Up</button>
          </div>
        </div>
      </div>
    </div>




    <footer>
      <p>
        <div class="copyright text-center text-xl-left text-muted">
        &copy; 2025
        <a href="#" class="font-weight-bold ml-1" target="_blank"
            >payvia</a
        >
        </div>
        <!-- Created with <i class="fa fa-heart"></i> by
        <a target="_blank" href="https://tech.ohipopo.com">OHIPStech</a> -->
      </p>
    </footer>

    <script>
      const signUpButton = document.getElementById("signUp");
      const signupInstead = document.getElementById("signupInstead");
      const signInButton = document.getElementById("signIn");
      const signinInstead = document.getElementById("signinInstead");
      const container = document.getElementById("container");
      const signinContainer = document.getElementById("sign-in-container") ;

      signUpButton.addEventListener("click", () => {
        container.classList.add("right-panel-active");
      });

      signInButton.addEventListener("click", () => {
        container.classList.remove("right-panel-active");
      });

      signinInstead.addEventListener("click", () => {
        container.classList.remove("right-panel-active");
        signinContainer.style.display = "flex" ;
      });

      signupInstead.addEventListener("click", () => {
        container.classList.add("right-panel-active");
        signinContainer.style.display = "none" ;
      });
    </script>

    <script>
      // ========== 🔐 OTP Input Setup and Verification ==========
      const inputs = document.querySelectorAll('.otp-input');
      const correctOTP = '123456'; // Placeholder for correct OTP
      const newPassword = document.getElementById('newPass');
      const forgotPassDiv = document.getElementById("forgotPassDiv");
      const userNameInput = document.getElementById("userName");
      const passwordInput = document.getElementById("newPasswordInput");
      const mainPassword = document.getElementById("mainPassword");
      const strengthDiv = document.getElementById("passwordResetStrengthVerification");
      const resetBtn = document.getElementById("resetPasswordBtn");
      const togglePassword = document.getElementById("togglePassword");
      const showIcon = document.getElementById("showIcon");
      const hideIcon = document.getElementById("hideIcon");
      const showPass = document.getElementById("showPass");
      const hidePass = document.getElementById("hidePass");
      const resetSuccessDiv = document.getElementById("resetSuccessfull");
      const signInContainer = document.getElementById("signInContainer");

      // Attach event listeners to OTP inputs
      inputs.forEach((input, index) => {
        // Restrict input to digits and auto-move focus
        input.addEventListener('input', () => {
          input.value = input.value.replace(/[^0-9]/g, '');
          if (input.value && index < inputs.length - 1) {
            inputs[index + 1].focus();
          }
          checkResetOTP(); // Validate OTP on input
        });

        // Handle backspace to move to previous field
        input.addEventListener('keydown', (e) => {
          if (e.key === 'Backspace' && !input.value && index > 0) {
            inputs[index - 1].focus();
          }
        });
      });

      /**
       * Verifies the entered OTP and shows the password reset form if valid
       */
      function checkResetOTP() {
        const enteredOTP = Array.from(inputs).map(i => i.value).join('');
        if (enteredOTP.length === 6) {
          if (enteredOTP === correctOTP) {
            forgotPassDiv.style.display = 'none';
            newPassword.style.display = 'flex';
          } else {
            alert('❌ Incorrect OTP. Try again.');
            inputs.forEach(input => input.value = '');
            inputs[0].focus();
          }
        }
      }

      /**
       * Initializes the forgot password process
       * Checks username and displays OTP screen if valid
       */
      function forgotPassword() {
        const userName = userNameInput.value.trim();

        if (userName === "") {
          userNameInput.style.border = "2px solid red";
          userNameInput.focus();
        } else {
          userNameInput.style.border = "";
          signInContainer.style.display = "none";

          // [TODO] Replace with actual check if username exists and fetch phone
          forgotPassDiv.style.display = 'flex';
          startOTPTimer();
        }
      }

      // ========== ⏳ OTP Countdown Timer Setup ==========
      const resendBtn = document.getElementById("resendOTP");
      const countdownSpan = document.getElementById("secLeftToSendOTP");
      let countdown = 59;

      resendBtn.style.display = "none"; // Hide initially

      /**
       * Starts a 60-second countdown for resending OTP
       */
      function startOTPTimer() {
        countdown = 59;
        resendBtn.style.display = "none";
        countdownSpan.textContent = countdown;

        const timer = setInterval(() => {
          countdown--;
          countdownSpan.textContent = countdown;

          if (countdown <= 0) {
            clearInterval(timer);
            resendBtn.style.display = "inline-block";
            countdownSpan.textContent = "0";
          }
        }, 1000);
      }

      // Handle resend OTP click
      resendBtn.addEventListener("click", () => {
        // [TODO] Replace with actual API call to resend OTP
        alert("OTP resent to your phone number.");
        startOTPTimer();
      });

      // ========== 🔑 Password Strength Rules ==========
      const rules = [
        {
          id: "newLengthRule",
          text: "At least 8 characters",
          test: pw => pw.length >= 8
        },
        {
          id: "newUpperRule",
          text: "At least one uppercase letter (A-Z)",
          test: pw => /[A-Z]/.test(pw)
        },
        {
          id: "newLowerRule",
          text: "At least one lowercase letter (a-z)",
          test: pw => /[a-z]/.test(pw)
        },
        {
          id: "newNumberRule",
          text: "At least one number (0-9)",
          test: pw => /[0-9]/.test(pw)
        },
        {
          id: "newSpecialCharRule",
          text: "At least one special character (!@#$%^&*)",
          test: pw => /[!@#\$%\^&\*]/.test(pw)
        }
      ];

      /**
       * Renders all password rules on page load
       */
      function renderRules() {
        strengthDiv.innerHTML = "";
        rules.forEach(rule => {
          const ruleElement = document.createElement("div");
          ruleElement.id = rule.id;
          ruleElement.innerHTML = `❌ ${rule.text}`;
          ruleElement.style.color = "#8a8a8a";
          strengthDiv.appendChild(ruleElement);
        });
      }

      /**
       * Updates password strength indicators based on user input
       */
      function updateStrengthDisplay(password) {
        let allPassed = true;

        rules.forEach(rule => {
          const ruleElement = document.getElementById(rule.id);
          const passed = rule.test(password);

          ruleElement.innerHTML = `${passed ? '✅' : '❌'} ${rule.text}`;
          ruleElement.style.color = passed ? "green" : "#8a8a8a";

          if (!passed) allPassed = false;
        });

        // Enable or disable the Reset button based on validation
        resetBtn.disabled = !allPassed;
      }

      // ========== 👁️ Toggle Password Visibility ==========
      togglePassword.addEventListener("click", () => {
        const isHidden = passwordInput.type === "password";
        passwordInput.type = isHidden ? "text" : "password";
        showIcon.style.display = isHidden ? "none" : "inline";
        hideIcon.style.display = isHidden ? "inline" : "none";
      });

      toggleMainPassword.addEventListener("click", () => {
        const isHidden = mainPassword.type === "password";
        mainPassword.type = isHidden ? "text" : "password";
        showPass.style.display = isHidden ? "none" : "inline";
        hidePass.style.display = isHidden ? "inline" : "none";
      });

      // ========== ✅ Password Reset Success Logic ==========
      resetBtn.addEventListener("click", () => {
        if (resetBtn.disabled) return;

        newPassword.style.display = 'none';
        resetSuccessDiv.style.display = "flex";
        resetSuccessDiv.style.alignItems = "center";
      });

      /**
       * Returns user to the login screen after successful reset
       */
      function loginBtn() {
        resetSuccessDiv.style.display = "none";
        signInContainer.style.display = "flex";
      }

      // ========== 🚀 Init on Page Load ==========
      renderRules(); // Show rules on load
      passwordInput.addEventListener("input", () => updateStrengthDisplay(passwordInput.value));

    </script>




    <script>

      //////////////////////////////////////
      // USER REGISTRATION MODULE
      //////////////////////////////////////

      // === Element References ===
      const nameInput = document.getElementById("name");
      const usernameInput = document.getElementById("usersNameRegister");
      const usernameStatus = document.getElementById("usernameStatus");
      const registerBtn = document.getElementById("registerBtn");
      const toggleRegisterPassword = document.getElementById("toggleRegisterPassword");
      const showRegisterPass = document.getElementById("showRegisterPass");
      const hideRegisterPass = document.getElementById("hideRegisterPass");
      const registerPassword = document.getElementById("registerPassword");
      const passwordStrengthDiv = document.getElementById("signupPasswordResetStrengthVerification");
      const phoneInput = document.getElementById("textFieldPhone");
      const phoneStatus = document.getElementById("phoneError");
      const username_pass = document.getElementById("username_pass");
      const phoneNumberPass = document.getElementById("phoneNumberPass");

      // === Validation Flags ===
      let isUsernameValid = false;
      let isPasswordStrong = false;
      let isPhoneValid = false;

      // === Simulated Existing Usernames (for demo) ===
      const existingUsernames = ["sama_yanick", "john_doe", "mary_smith"];

      //////////////////////////////////////
      // PASSWORD STRENGTH VALIDATION
      //////////////////////////////////////

      const signupPassRules = [
        { id: "lengthRule", text: "At least 8 characters", test: (pw) => pw.length >= 8 },
        { id: "upperRule", text: "At least one uppercase letter (A-Z)", test: (pw) => /[A-Z]/.test(pw) },
        { id: "lowerRule", text: "At least one lowercase letter (a-z)", test: (pw) => /[a-z]/.test(pw) },
        { id: "numberRule", text: "At least one number (0-9)", test: (pw) => /[0-9]/.test(pw) },
        { id: "specialCharRule", text: "At least one special character (!@#$%^&*)", test: (pw) => /[!@#\$%\^&\*]/.test(pw) }
      ];

      // Show/Hide password strength div
      function toggleStrengthDiv() {
        passwordStrengthDiv.style.display = (document.activeElement === registerPassword || registerPassword.value.trim().length > 0)
          ? "block"
          : "none";
      }
      registerPassword.addEventListener("focus", toggleStrengthDiv);
      registerPassword.addEventListener("input", toggleStrengthDiv);
      registerPassword.addEventListener("blur", () => {
        if (registerPassword.value.trim().length === 0) passwordStrengthDiv.style.display = "none";
      });

      // Render password rules
      function renderRulesRegister() {
        passwordStrengthDiv.innerHTML = "";
        signupPassRules.forEach(rule => {
          const div = document.createElement("div");
          div.id = rule.id;
          div.innerHTML = `❌ ${rule.text}`;
          div.style.color = "#8a8a8a";
          passwordStrengthDiv.appendChild(div);
        });
      }

      // Update rules as user types
      function updateRegisterStrengthDisplay(password) {
        let allPassed = true;

        signupPassRules.forEach(rule => {
          const ruleDiv = document.getElementById(rule.id);
          const passed = rule.test(password);
          ruleDiv.innerHTML = `${passed ? '✅' : '❌'} ${rule.text}`;
          ruleDiv.style.color = passed ? "green" : "#8a8a8a";
          if (!passed) allPassed = false;
        });

        isPasswordStrong = allPassed;
        validateAllFields();
      }

      renderRulesRegister();

      registerPassword.addEventListener("input", () => {
        updateRegisterStrengthDisplay(registerPassword.value);
      });

      // Toggle password visibility
      toggleRegisterPassword.addEventListener("click", () => {
        const isPassword = registerPassword.getAttribute("type") === "password";
        registerPassword.setAttribute("type", isPassword ? "text" : "password");
        showRegisterPass.style.display = isPassword ? "none" : "inline";
        hideRegisterPass.style.display = isPassword ? "inline" : "none";
      });

      //////////////////////////////////////
      // USERNAME VALIDATION
      //////////////////////////////////////

      async function checkUsernameAvailability(username) {
        await new Promise(resolve => setTimeout(resolve, 300)); // Simulate delay
        return !existingUsernames.includes(username.toLowerCase());
      }

      async function suggestAndSetUsername(name) {
        const base = name.trim().toLowerCase().replace(/\s+/g, "_").replace(/[^a-z0-9_]/g, "");
        let username = base;
        let suffix = 1;

        while (!(await checkUsernameAvailability(username))) {
          username = `${base}_${suffix++}`;
        }

        usernameInput.value = username;
        validateUsername(username);
      }

      async function validateUsername(username) {
        const available = await checkUsernameAvailability(username);

        if (username.length < 3) {
          usernameStatus.innerText = "Username too short.";
          usernameStatus.style.color = "red";
          username_pass.style.display = "none";
          isUsernameValid = false;
        } else if (!available) {
          usernameStatus.innerText = "Username already taken.";
          usernameStatus.style.color = "red";
          username_pass.style.display = "none";
          isUsernameValid = false;
        } else {
          usernameStatus.innerText = "";
          usernameInput.style.borderColor = "green";
          username_pass.style.display = "block";
          isUsernameValid = true;
        }

        validateAllFields();
      }

      nameInput.addEventListener("input", () => {
        const name = nameInput.value.trim();
        if (name.length > 2) {
          suggestAndSetUsername(name);
        } else {
          usernameInput.value = "";
          usernameStatus.innerText = "";
          isUsernameValid = false;
          validateAllFields();
        }
      });

      usernameInput.addEventListener("input", () => {
        validateUsername(usernameInput.value.trim().toLowerCase());
      });

      //////////////////////////////////////
      // PHONE NUMBER VALIDATION
      //////////////////////////////////////

      function isValidCameroonPhone(phone) {
        return /^6[5-9][0-9]{7}$/.test(phone);
      }

      async function checkPhoneNumberInDB(fullNumber) {
        try {
          const response = await fetch('check_phone.php?phone=' + encodeURIComponent(fullNumber));
          const data = await response.json();
          return data.available === true;
        } catch (error) {
          console.error("Phone check error:", error);
          return false;
        }
      }

      phoneInput.addEventListener("input", async () => {
        const raw = phoneInput.value.replace(/\D/g, '').slice(0, 9);
        phoneInput.value = raw;

        const fullPhone = raw;

        if (!isValidCameroonPhone(raw)) {
          phoneStatus.innerText = "Enter a valid Cameroon mobile number (format: 6xxxxxxxx)";
          phoneStatus.style.color = "red";
          phoneInput.style.borderColor = "red";
          phoneNumberPass.style.display = "none";
          isPhoneValid = false;
          validateAllFields();
          return;
        }

        const isAvailable = await checkPhoneNumberInDB(fullPhone);

        if (!isAvailable) {
          phoneStatus.innerText = "";
          phoneStatus.style.color = "green";
          phoneNumberPass.style.display = "block";
          phoneInput.style.borderColor = "green";
          isPhoneValid = true;
        } else {
          phoneStatus.innerText = "Phone number is already registered ❌";
          phoneStatus.style.color = "red";
          phoneInput.style.borderColor = "red";
          phoneNumberPass.style.display = "none";
          isPhoneValid = false;
        }

        validateAllFields();
      });

      //////////////////////////////////////
      // FINAL VALIDATION + SUBMISSION
      //////////////////////////////////////

      function validateAllFields() {
        const allPassed = isUsernameValid && isPasswordStrong && isPhoneValid;

        registerBtn.disabled = !allPassed;
        registerBtn.style.backgroundColor = allPassed ? "#c1ff72" : "#ccc";
        registerBtn.style.cursor = allPassed ? "pointer" : "not-allowed";
      }

      // Default button state
      registerBtn.disabled = true;
      registerBtn.style.backgroundColor = "#ccc";
      registerBtn.style.cursor = "not-allowed";

      // === FORM SUBMISSION FUNCTION ===
      function handleRegistration() {
        const name = nameInput.value.trim();
        const username = usernameInput.value.trim();
        const phone = phoneInput.value.trim();
        const password = registerPassword.value;

        const data = { name, username, phone, password };
        console.log("✅ Registration data submitted:", data);

        // Generate a random 6-digit OTP
        const generatedOTP = Math.floor(100000 + Math.random() * 900000).toString();
        sessionStorage.setItem("otp_code", generatedOTP); // Store temporarily for verification

        // Send OTP via your SMS API
        const message = encodeURIComponent(`Your OTP code is: ${generatedOTP}Frs`);
        const main_username = "samayanick0074@gmail.com"; // replace with actual
        const main_password = "ohipopo2024"; // replace with actual
        const senderId = "Ohipopo"; // optional: depends on your account setup
        const smsAPI = `https://smsvas.com/bulk/public/index.php/api/v1/sendsms?user=${main_username}&password=${main_password}&senderid=${senderId}&sms=${message}&mobiles=${phone}`;

        fetch(smsAPI)
          .then(res => res.json())
          .then(result => {
            console.log("📨 OTP sent:", result);

            // Show the OTP verification screen
            document.getElementById("signupContainer").style.display = "none";
            document.getElementById("phoneVerification").style.display = "flex";

            let countdown = 59;
            const resendBtn = document.getElementById("resendVerificationOTP");
            const timerSpan = document.getElementById("secLeftToSendVerificationOTP");
            resendBtn.style.display = "none";

            function startOTPTimer() {
              countdown = 59;
              resendBtn.style.display = "none";
              timerSpan.textContent = countdown;
              const timer = setInterval(() => {
                countdown--;
                timerSpan.textContent = countdown;
                if (countdown <= 0) {
                  clearInterval(timer);
                  resendBtn.style.display = "inline-block";
                  timerSpan.textContent = "0";
                }
              }, 1000);
            }

            startOTPTimer();

            // Allow OTP resend
            resendBtn.onclick = () => {
              handleRegistration(); // Resend triggers the whole function again
            };

            // OTP verification
            const otpInputs = document.querySelectorAll(".otp-input-registration");
            const otpContainer = document.getElementById("otpSubmitContainer");

            otpInputs.forEach((input, index) => {
              input.addEventListener("input", () => {
                input.value = input.value.replace(/\D/g, "").slice(0, 1); // Allow only 1 digit
                if (input.value && index < otpInputs.length - 1) {
                  otpInputs[index + 1].focus();
                }
                checkFullOTP();
              });
            });

            function checkFullOTP() {
              const enteredRegistrationOTP = Array.from(otpInputs).map(input => input.value).join("");
              if (enteredRegistrationOTP.length === 6) {
                if (enteredRegistrationOTP === sessionStorage.getItem("otp_code")) {
                  alert("✅ Phone verified successfully!");
                  submitToBackend(data); // Submit final registration
                } else {
                  alert("❌ Incorrect OTP. Please try again.");
                  otpInputs.forEach(input => (input.value = ""));
                  otpInputs[0].focus();
                  startOTPTimer(); // Restart countdown
                }
              }
            }

          })
          .catch(err => {
            console.error("❌ Error sending OTP:", err);
            alert("Failed to send OTP. Please try again.");
          });
      }

      // Final submission function (adjust URL/API as needed)
      function submitToBackend(data) {
        fetch('http://localhost/rise-sms/api/v_1/register/basic_info', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(data)
      })
        .then(async res => {
          const text = await res.text();
          try {
            const json = JSON.parse(text);
            console.log("✅ Registration successful:", json);
          } catch (e) {
            console.error("❌ Server returned non-JSON (maybe PHP error):", text);
            alert("Server error: Please check your backend logs.");
          }
        })
        .catch(err => {
          console.error("❌ Submission error:", err);
          alert("Failed to contact server.");
        });

      }


      // === Trigger form submission on click ===
      registerBtn.addEventListener("click", function(e) {
        e.preventDefault(); // Prevent default form submission (e.g., page reload)
        handleRegistration(); // Call your custom registration function
      });



    </script>




    <!-- Argon Scripts -->
    <!-- Core -->
    <script src="dashboard/assets/vendor/jquery/dist/jquery.min.js"></script>
    <script src="dashboard/assets/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="dashboard/assets/vendor/js-cookie/js.cookie.js"></script>
    <script src="dashboard/assets/vendor/jquery.scrollbar/jquery.scrollbar.min.js"></script>
    <script src="dashboard/assets/vendor/jquery-scroll-lock/dist/jquery-scrollLock.min.js"></script>
    <!-- Optional JS -->
    <script src="dashboard/assets/vendor/chart.js/dist/Chart.min.js"></script>
    <script src="dashboard/assets/vendor/chart.js/dist/Chart.extension.js"></script>
    <!-- Argon JS -->
    <script src="dashboard/assets/js/dashboard.js?v=1.2.0"></script>
    <!-- Demo JS - remove this in your project -->
    <script src="dashboard/assets/js/demo.min.js"></script>
  </body>
</html>
