<?php

  include 'includes/head.php';
  include 'includes/nav.php';

?>
      <!-- Page content -->
      <div class="container-fluid">
        <div class="row justify-content-center">
          <div class="col-lg-6 col-md-7">

            <!-- Tabs -->
            <div class="tabs text-center">
                <div class="tab active" onclick="switchTab('current')">SMS Home</div>
                <div class="tab" onclick="switchTab('history')">SMS Log</div>
            </div>

            <!-- Active Div -->
            <div id="current-loan" class="call-list active">
                <div class="card" style="box-shadow: 0 0 2rem 0 rgb(136 152 170 / 0%);">
                    <div class="slider-wrapper" style="overflow: hidden;">
                        <div class="swiper mySwiper">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide" style="width: 100%; height: 216px;">
                                <div class="card-body sms-bg rounded p-4">
                                    <!-- First card content here -->
                                    <div class="row justify-content-between align-items-center">
                                    <div class="col">
                                        <h1 class="text-dark"><i class="fa-regular fa-comments"></i>  SMS Account</h1>
                                    </div>
                                    <div class="col-auto">
                                        <span class="badge badge-lg badge-success"><i class="fa-solid fa-circle-check"></i> Active</span>
                                    </div>
                                    </div>
                                    <div class="">
                                        <h1 class="text-dark account-balance" id="sms_balance">
                                            
                                        </h1>
                                    </div>
                                    <div class="row">
                                        <div class="col balance-card-buttons">
                                            <a href="buy-sms">
                                                <span class="d-block h3 text-dark buy-sms-btn"
                                            ><i class="fa-solid fa-comments-dollar"></i>
                                            Buy SMS</span
                                            >
                                            </a>
                                        </div>
                                    </div>
                                    <i class="fa-regular fa-comments smsStyle1"></i>
                                </div>
                            </div>

                        </div>
                        </div>
                    </div>
                </div>


                <div class="services">
                    <h2>Menu</h2>
                    <div class="card">
                        <div class="card-body services_card">
                            <div class="services-section">

                                <div class="item-services shortcut-item">
                                    <a href="send_sms">
                                        <span
                                        class="shortcut-media avatar rounded-circle "
                                        >
                                        <i class="fa-regular fa-comment"></i>
                                        </span>
                                        <small>Send SMS</small>
                                    </a>
                                </div>
                                <!-- <div class="item-services shortcut-item">
                                    <a href="#!">
                                        <span
                                        class="shortcut-media avatar rounded-circle "
                                        >
                                        <i class="fa-regular fa-comments"></i>
                                        </span>
                                        <small>Bulk SMS</small>
                                    </a>
                                </div> -->
                                <!-- <div class="item-services shortcut-item">
                                    <a href="#!">
                                        <span
                                        class="shortcut-media avatar rounded-circle "
                                        >
                                        <i class="fa-regular fa-user"></i>
                                        </span>
                                        <small>Personalised SMS</small>
                                    </a>
                                </div> -->
                                <div class="item-services shortcut-item">
                                    <a href="#!">
                                        <span
                                        class="shortcut-media avatar rounded-circle "
                                        >
                                        <i class="fa-regular fa-address-book"></i>
                                        </span>
                                        <small>Contacts</small>
                                    </a>
                                </div>
                                <div class="item-services shortcut-item">
                                    <a href="sms-api-documentation.html">
                                        <span
                                        class="shortcut-media avatar rounded-circle "
                                        >
                                        <i class="fa-solid fa-code"></i>
                                        </span>
                                        <small>API</small>
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="transactions mb-4">
                    <div class="row justify-content-between align-items-center ">
                        <div class="col">
                            <h2>Sender Names <span onclick="openIphoneModal()" class="add-sender_id"><i class="fa-solid fa-plus"></i> ADD</span></h2>
                        </div>
                        <div class="col-auto">
                            <span onclick="openAPIKey()" class="add-sender_id"><i class="fa-solid fa-key"></i> API Key</span>
                            <button id="apiToggleBtn" type="button" class="btn btn-sm btn-toggle" data-toggle="button" aria-pressed="" autocomplete="off">
                                <div class="handle"></div>
                            </button>
                        </div>
                    </div>
                    <div class="table-responsive  mt-2">
                        <div class="link-color mb-3" id="senderIds">
                            
                            <!-- ROW 1 STARTS -->
                            <div class="row justify-content-between align-items-center mb-2">
                                <div class="cols">
                                    <div class="d-flex">
                                      <div class="flex-details" id="AllSenderIds">
                                          
                                      </div>
                                    </div>
                                </div>
                            </div>
                            <!-- ROW 1 ENDS -->
                            
                        </div>
                    </div>
                </div>
                

                <!-- Trasactions section  -->
                <div class="transactions">
                    <div class="row justify-content-between align-items-center">
                        <div class="col">
                          <h2>Recent Transactions </h2>
                        </div>
                        <div class="col-auto">
                          <a href="transactions"><span class="badge badge-lg view-more">View More...</span></a>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                  <th scope="col" class="sort" data-sort="name">Date</th>
                                  <th scope="col" class="sort" data-sort="budget">
                                      Amount
                                  </th>
                                  <th scope="col" class="sort" data-sort="status">
                                      Status
                                  </th>
                                  <th scope="col" class="sort" data-sort="completion">
                                      Type
                                  </th>
                                  <th scope="col">SMS Credit</th>
                                </tr>
                            </thead>
                            <tbody class="list" id="transactionTableBody">
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            

            <!-- SMS logs page -->
            <div id="history-loan" class="call-list">
                <h2>SMS Logs</h2>
                <br>
                <div class="row filter">
                    <div class="group" >    
                        <input type="date" id="startDate" >
                        <label for="">Start Date</label>
                    </div>
                    <div class="group">    
                        <input type="date" id="endDate">
                        <label for="">End Date</label>
                    </div>
                    <button class="shortcut-media avatar rounded-circle" onclick="fetchSMSLogs()">
                        <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                </div>
                <br>
                <div class="table-responsive">
                    <table class="table align-items-center table-flush">
                        <thead class="thead-light">
                            <tr>
                                <th scope="col" class="sort" data-sort="date">Date</th>
                                <th scope="col" class="sort" data-sort="amount">
                                    Number
                                </th>
                                <th scope="col" class="sort" data-sort="status">
                                    Sender
                                </th>
                                <th scope="col" class="sort" data-sort="credit">Status</th>
                                <th scope="col" class="sort" data-sort="credit">Consumption</th>
                                <th scope="col" class="sort" data-sort="type">
                                    Message
                                </th>
                            </tr>
                        </thead>
                        <tbody class="list" id="smsLogs">
                            
                        </tbody>
                    </table>
                </div>
            </div>
            
            <div class="modal-backdrop"></div>
            <div class="iphone-modal" id="bottomModal" style="width: 570px !important;">
                <div class="drag-indicator" onclick="closeIphoneModal()"></div>
                <div class="iphone-modal-content">
                    <h3>Hello! <span id="loggedin_username"></span></h3>
                    <p>You can register more sender IDs here. It must be in length of maximum 11 characters</p>
                </div>
                <div class="loan-details-container">
                    <div class="group" style="margin-bottom: 0px;">    
                        <input type="text" id="senderId" required>
                        <label for="">Sender ID</label>
                    </div>
                    <div class="group mt-3">    
                        <input  style="height: 100px;" type="text" id="sampleMessage" required>
                        <label for="">Sample Message</label>
                    </div>
                    <input type="hidden" id="loginUserId" >
                    <div class="text-danger" id="errorLogs">Error</div>
                </div>
                <button onclick="saveSenderId()" type="button" class="btn btn-primary btn-lg btn-block mt-5" style="border-radius: 24px;">Add</button>
            </div>
        </div>
    </div>

       


    <!-- API key Modal-->
    <div id="api-key-modal" class="iphone-modal-overlay">
        <div class="iphone-alert-modal" style="max-width: 600px;">
            <div class="iphone-modal-content">
                <div id="currentApiKey"></div>
                <div class="api-action">
                  <span class="copy-sms-api-key api-key-btn-action" onclick="copyApiKey()">
                    <i class="fa-regular fa-copy"></i>
                  </span>
                  <span class="regenerate-sms-api_key api-key-btn-action" onclick="regenerateApiKey()">
                    <i class="fa-solid fa-arrows-rotate"></i>
                  </span>
                </div>
              </div>
              
            <div class="iphone-modal-actions">
                <a onclick="closeApiKeyModal()" class="btn-ok">Close</a>
            </div>
        </div>
    </div>


    <!-- LOADING MODAL -->
    <div id="loaderGIF" class="iphone-modal-overlay">
        <div class="iphone-alert-moda">
            <div class="iphone-modal-content">
                <img src="../../assets/img/rise_logo_gif.gif" alt="" style="width: 50px;">
            </div>
        </div>
    </div>


   

<script src="../../assets/js/bulk_sms.js"></script>
<script src="../../assets/js/smsLogs.js"></script>
<?php
  include 'includes/footer.php' ;
?>