<?php
header('Content-Type: application/json');

// Simulate DB connection
include 'db_config.php';

if (!isset($_GET['phone'])) {
    echo json_encode(['error' => 'No phone provided']);
    exit;
}

$phone = $_GET['phone'];

// Sanitize input
$phone = preg_replace('/[^0-9+]/', '', $phone);

// Query DB
$stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE phone_number = ?");
$stmt->execute([$phone]);
$count = $stmt->fetchColumn();

echo json_encode(['available' => $count == 0]);
?>
