      /* ============================================================================
          GLOBAL VARIABLES & DOM ELEMENTS
      ============================================================================ */
      const username          = sessionStorage.getItem("username");

      /* ============================================================================
          1. INITIAL USER DATA FETCH
      ============================================================================ */
      fetch(`http://localhost/rise-sms/api/v_1/user/get_user_details?username=${encodeURIComponent(username)}`, {
        method: 'GET',
        headers: { 'Authorization': username }
      })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            displayUserDetails(data.user);
            renderSenderIds(data.sender_ids);
          }
        })
        .catch(err => console.error("❌ User data fetch error:", err));

      /**
       * Display main user details on UI.
       */
      function displayUserDetails(user) {
        const firstName = user.name.split(" ")[0];
        document.getElementById("customer_name").innerText      = firstName;

      }



      /* ============================================================================
          2. FETCH & DISPLAY TRANSACTIONS
      ============================================================================ */
      async function fetchTransactions() {
        try {
          const response = await fetch("http://localhost/rise-sms/api/v_1/transactions/complete_tranactions");
          const result = await response.json();

          if (result.success) {
            const tbody = document.getElementById("transactionTableBody");
            tbody.innerHTML = "";

            result.transactions.forEach(tx => {
              const row = document.createElement("tr");
              row.innerHTML = `
                <td>${new Date(tx.created_at).toLocaleString()}</td>
                <td>${parseFloat(tx.amount).toLocaleString()} ${tx.currency || 'XAF'}</td>
                <td><span class="badge ${getStatusClass(tx.status)}">${capitalize(tx.status)}</span></td>
                <td>${capitalize(tx.transaction_type)}</td>
                <td>${tx.sms_credit || '-'}</td>
              `;
              tbody.appendChild(row);
            });
          } else {
            alert("❌ " + result.error);
          }

        } catch (err) {
          console.error("❌ Transaction fetch error:", err);
          alert("Could not load transactions.");
        }
      }

      function getStatusClass(status) {
        switch (status) {
          case "completed": return "badge-success";
          case "pending": return "badge-warning";
          case "failed": return "badge-danger";
          case "cancelled": return "badge-secondary";
          default: return "badge-light";
        }
      }

      function capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
      }

      // Initialize transaction load on page load
      fetchTransactions();