function openLoader() {
    document.getElementById('loaderGIF').style.display = 'flex';
}

function closeLoader() {
    document.getElementById('loaderGIF').style.display = 'none';
}


async function fetchSMSLogs() {
    openLoader(); // Start the loader when the function starts
    const startDate = document.getElementById("startDate").value;
    const endDate = document.getElementById("endDate").value;
  
    let url = "http://localhost/rise-sms/api/v_1/sms/sms_logs";
  
    // Append date filters if they are selected
    const params = [];
    if (startDate) params.push(`startDate=${encodeURIComponent(startDate)}`);
    if (endDate) params.push(`endDate=${encodeURIComponent(endDate)}`);
    if (params.length > 0) url += `?${params.join("&")}`;
  
    try {
      const response = await fetch(url);
      const result = await response.json();
  
      if (result.success) {
        closeLoader() ; // Close the loader to display data
        const tbody = document.getElementById("smsLogs");
        tbody.innerHTML = "";
  
        result.logs.forEach(lgs => {
          const row = document.createElement("tr");
          row.innerHTML = `
            <td>${new Date(lgs.created_at).toLocaleString()}</td>
            <td>${lgs.recipient}</td>
            <td>${lgs.sender_id}</td>
            <td><span class="badge ${getStatusClass(lgs.status)}">${capitalize(lgs.status)}</span></td>
            <td>${lgs.message_parts} SMS</td>
            <td>${decodeURIComponent(lgs.message.replace(/\+/g, ' '))}</td>
          `;
          tbody.appendChild(row);
        });
      } else {
        alert("❌ " + result.error);
        closeLoader() ; // Close the loader to display error
      }

      function getStatusClass(status) {
        switch (status) {
          case "success": return "badge-success";
          case "pending": return "badge-warning";
          case "failed": return "badge-danger";
          case "cancelled": return "badge-secondary";
          default: return "badge-light";
        }
      }
  
    } catch (err) {
      console.error("❌ Logs fetch error:", err);
      alert("Could not load SMS logs.");
    }
  }

  