// sessionCheck.js

fetch('http://localhost/rise-sms/api/v_1/authenticate/check_session')
  .then(res => res.json())
  .then(data => {
    if (!data.authenticated) {
      // Redirect to login if user is not authenticated
      window.location.href = "../../../login";
    } else {
      console.log("✅ Authenticated as", data.username);

      // OPTIONAL: Save username to sessionStorage for other uses
      // sessionStorage.setItem("username", data.username);

      // OPTIONAL: Prevent access to login or register pages if already logged in
      const currentPage = window.location.pathname;

      if (currentPage.includes("login.html") || currentPage.includes("register.html")) {
        window.location.href = "onboarding.html";
      }
    }
  })
  .catch(error => {
    console.error("❌ Session check failed:", error);
    // Optionally redirect or show offline message
  });


  