
    const signUpButton = document.getElementById("signUp");
    const signupInstead = document.getElementById("signupInstead");
    const signInButton = document.getElementById("signIn");
    const signinInstead = document.getElementById("signinInstead");
    const container = document.getElementById("container");
    const signinContainer = document.getElementById("sign-in-container") ;

    signUpButton.addEventListener("click", () => {
    container.classList.add("right-panel-active");
    });

    signInButton.addEventListener("click", () => {
    container.classList.remove("right-panel-active");
    });

    signinInstead.addEventListener("click", () => {
    container.classList.remove("right-panel-active");
    signinContainer.style.display = "flex" ;
    });

    signupInstead.addEventListener("click", () => {
    container.classList.add("right-panel-active");
    signinContainer.style.display = "none" ;
    });




    // ========== 🔐 OTP Input Setup and Verification ==========
    const inputs = document.querySelectorAll('.otp-input');
    let generatedforgotPWDOTP = ''; // Placeholder for correct OTP
    const newPassword = document.getElementById('newPass');
    const forgotPassDiv = document.getElementById("forgotPassDiv");
    const userNameInput = document.getElementById("userName");
    const passwordInput = document.getElementById("newPasswordInput");
    const mainPassword = document.getElementById("mainPassword");
    const strengthDiv = document.getElementById("passwordResetStrengthVerification");
    const resetBtn = document.getElementById("resetPasswordBtn");
    const togglePassword = document.getElementById("togglePassword");
    const showIcon = document.getElementById("showIcon");
    const hideIcon = document.getElementById("hideIcon");
    const showPass = document.getElementById("showPass");
    const hidePass = document.getElementById("hidePass");
    const resetSuccessDiv = document.getElementById("resetSuccessfull");
    const signInContainer = document.getElementById("signInContainer");
    const login_error_display = document.getElementById("login_error_display") ;


    ///======= This is a login function =======/////////////

    async function loginUser() {
    const username = userNameInput.value.trim();
    const password = mainPassword.value;

    // SHOW LOADER
    document.getElementById("loadingModal").style.display = "flex";

    if (!username || !password) {
        login_error_display.innerHTML = "Please enter both username and password." ;
        login_error_display.style.display = "block" ;
        // HIDE LOADER
        document.getElementById("loadingModal").style.display = "none";
        return;
    }

    try {
        const response = await fetch('http://localhost/rise-sms/api/v_1/authenticate/auth_user', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ username, password })
        });

        const result = await response.json();

        if (response.ok && result.success) {
            // Display errors on the Error div
            // Store session data if needed
            sessionStorage.setItem("username", result.username);
            login_error_display.style.display = "none" ;
            // Redirect to onboarding or dashboard
            window.location.href = "dashboard/en/cm/";
            } else {
            // Display errors on the Error div
            login_error_display.innerHTML = result.error || "Invalid credentials." ;
            login_error_display.style.display = "block" ;
            // HIDE LOADER
            document.getElementById("loadingModal").style.display = "none";
        }

    } catch (error) {
        // Display errors on the Error div
        login_error_display.innerHTML = "Login failed. Please try again later." ;
        login_error_display.style.display = "block" ;
        // HIDE LOADER
        document.getElementById("loadingModal").style.display = "none";
    }
    }


    document.getElementById("signinUser").addEventListener("click", (e) => {
    e.preventDefault();
    loginUser();
    });


    /**
     * Initializes the forgot password process
     * Checks username and displays OTP screen if valid
     */
    function forgotPassword() {
    const userName = userNameInput.value.trim();

    if (userName === "") {
        userNameInput.style.border = "2px solid red";
        userNameInput.focus();
    } else {
        userNameInput.style.border = "";
        signInContainer.style.display = "none";


        // [TODO] Replace with actual check if username exists and fetch phone
        // This fetch API is to preload all users names from the db and store then in the let variable existingUsernames = [];
        async function verifyUsername(username) {
        try {
            const res = await fetch(`http://localhost/rise-sms/api/v_1/authenticate/verify_usernames?username=${username}`);
            const data = await res.json();

            if (data.success) {
            console.log("✅ Usernames loaded:", data.phone);
            return data.phone ;
            } else {
            throw new Error("Could not fetch usernames");
            }

        } catch (error) {
            // console.error("❌ Failed to fetch usernames:", error);
            return [];
        }
        }

        async function checkIfUserExists(userName) {
        const verifiesUsername = await verifyUsername(userName);

        if (!verifiesUsername) {
            login_error_display.style.display = "block" ;
            login_error_display.innerHTML = "❌ Username not found!" ;
            signInContainer.style.display = "flex";
        } else {
            //console.log("✅ Phone number tied to username:", verifiesUsername);
            // Show the loading modal
            document.getElementById("loadingModal").style.display = "flex";

            // Generate a random 6-digit OTP
            generatedforgotPWDOTP = Math.floor(100000 + Math.random() * 900000).toString();
            sessionStorage.setItem("otp_code", generatedforgotPWDOTP); // Store temporarily for verification

            // Send OTP via your SMS API
            const forgot_message = encodeURIComponent(`Your OTP code is "${generatedforgotPWDOTP}". Do not share with anyone`);
            const forgot_main_username = "samayanick0074@gmail.com"; // replace with actual
            const forgot_main_password = "ohipopo2024"; // replace with actual
            const forgot_senderId = "Ohipopo"; // optional: depends on your account setup
            const forgot_smsAPI = `https://smsvas.com/bulk/public/index.php/api/v1/sendsms?user=${forgot_main_username}&password=${forgot_main_password}&senderid=${forgot_senderId}&sms=${forgot_message}&mobiles=${verifiesUsername}`;

            fetch(forgot_smsAPI)
            .then(res => res.json())
            .then(results => {
                // console.log("📨 OTP sent:", result);

                function maskCameroonPhoneNumber(verifiesUsername) {
                // Ensure phone starts with +237 and is at least 12 characters
                if (!verifiesUsername.startsWith("+237") || verifiesUsername.length !== 13) {
                    return "Invalid phone number format";
                }

                // Extract and mask the number
                const prefix = verifiesUsername.substring(0, 5);        // +2376
                const lastTwo = verifiesUsername.slice(-2);             // last 2 digits
                return `${prefix} *** *** ${lastTwo}`;
                }

                // Example
                const masked = maskCameroonPhoneNumber(verifiesUsername);

                document.getElementById("maskedNumber").innerHTML = masked ;

                // Hide loading modal now
                document.getElementById("loadingModal").style.display = "none";

                forgotPassDiv.style.display = 'flex';

                startResetOTPTimer();

            
            })
            .catch(err => {
            console.error("❌ Error sending OTP:", err);
            alert("Failed to send OTP. Please try again. vvvvv");
            });
            
        }
        }

        checkIfUserExists(userName);

    }
    }


    // Attach event listeners to OTP inputs
    inputs.forEach((input, index) => {
    // Restrict input to digits and auto-move focus
    input.addEventListener('input', () => {
        input.value = input.value.replace(/[^0-9]/g, '');
        if (input.value && index < inputs.length - 1) {
        inputs[index + 1].focus();
        }
        checkResetOTP(); // Validate OTP on input
    });

    // Handle backspace to move to previous field
    input.addEventListener('keydown', (e) => {
        if (e.key === 'Backspace' && !input.value && index > 0) {
        inputs[index - 1].focus();
        }
    });
    });

    /**
     * Verifies the entered OTP and shows the password reset form if valid
     */
    function checkResetOTP() {
    const enteredOTP = Array.from(inputs).map(i => i.value).join('');
    if (enteredOTP.length === 6) {
        if (enteredOTP === generatedforgotPWDOTP) {
        forgotPassDiv.style.display = 'none';
        newPassword.style.display = 'flex';
        } else {
        alert('❌ Incorrect OTP. Try again.');
        inputs.forEach(input => input.value = '');
        inputs[0].focus();
        }
    }
    }

    // ========== ⏳ OTP Countdown Timer Setup ==========
    const resendBtn = document.getElementById("resendOTP");
    const countdownSpan = document.getElementById("secLeftToSendOTP");
    let countdown = 59;

    resendBtn.style.display = "none"; // Hide initially

    /**
     * Starts a 60-second countdown for resending OTP
     */
    function startResetOTPTimer() {
    countdown = 59;
    resendBtn.style.display = "none";
    countdownSpan.textContent = countdown;

    const timer = setInterval(() => {
        countdown--;
        countdownSpan.textContent = countdown;

        if (countdown <= 0) {
        clearInterval(timer);
        resendBtn.style.display = "inline-block";
        countdownSpan.textContent = "0";
        }
    }, 1000);
    }

    // Handle resend OTP click
    resendBtn.addEventListener("click", () => {
    // [TODO] Replace with actual API call to resend OTP
    // alert("OTP resent to your phone number.");
    forgotPassword();
    });

    // ========== 🔑 Password Strength Rules ==========
    const rules = [
    {
        id: "newLengthRule",
        text: "At least 8 characters",
        test: pw => pw.length >= 8
    },
    {
        id: "newUpperRule",
        text: "At least one uppercase letter (A-Z)",
        test: pw => /[A-Z]/.test(pw)
    },
    {
        id: "newLowerRule",
        text: "At least one lowercase letter (a-z)",
        test: pw => /[a-z]/.test(pw)
    },
    {
        id: "newNumberRule",
        text: "At least one number (0-9)",
        test: pw => /[0-9]/.test(pw)
    },
    {
        id: "newSpecialCharRule",
        text: "At least one special character (!@#$%^&*)",
        test: pw => /[!@#\$%\^&\*]/.test(pw)
    }
    ];

    /**
     * Renders all password rules on page load
     */
    function renderRules() {
    strengthDiv.innerHTML = "";
    rules.forEach(rule => {
        const ruleElement = document.createElement("div");
        ruleElement.id = rule.id;
        ruleElement.innerHTML = `❌ ${rule.text}`;
        ruleElement.style.color = "#8a8a8a";
        strengthDiv.appendChild(ruleElement);
    });
    }

    /**
     * Updates password strength indicators based on user input
     */
    function updateStrengthDisplay(password) {
    let allPassed = true;

    rules.forEach(rule => {
        const ruleElement = document.getElementById(rule.id);
        const passed = rule.test(password);

        ruleElement.innerHTML = `${passed ? '✅' : '❌'} ${rule.text}`;
        ruleElement.style.color = passed ? "green" : "#8a8a8a";

        if (!passed) allPassed = false;
    });

    // Enable or disable the Reset button based on validation
    resetBtn.disabled = !allPassed;
    }

    // ========== 👁️ Toggle Password Visibility ==========
    togglePassword.addEventListener("click", () => {
    const isHidden = passwordInput.type === "password";
    passwordInput.type = isHidden ? "text" : "password";
    showIcon.style.display = isHidden ? "none" : "inline";
    hideIcon.style.display = isHidden ? "inline" : "none";
    });

    toggleMainPassword.addEventListener("click", () => {
    const isHidden = mainPassword.type === "password";
    mainPassword.type = isHidden ? "text" : "password";
    showPass.style.display = isHidden ? "none" : "inline";
    hidePass.style.display = isHidden ? "inline" : "none";
    });

    // ========== ✅ Password Reset Success Logic ==========
    resetBtn.addEventListener("click", () => {
    if (resetBtn.disabled) return;


    function update_password(username, new_password) {
        fetch('http://localhost/rise-sms/api/v_1/authenticate/reset_password', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({username, new_password})
        })
        .then(async res => {
        const text = await res.text();
        try {
            const json = JSON.parse(text);
            console.log("✅ Registration successful:", json);
            newPassword.style.display = 'none';
            resetSuccessDiv.style.display = "flex";
            resetSuccessDiv.style.alignItems = "center";
        } catch (e) {
            // console.error("❌ Server returned non-JSON (maybe PHP error):", text);
            // alert("Server error: Please check your backend logs.");
        }
        })
        .catch(err => {
        // console.error("❌ Submission error:", err);
        // alert("Failed to contact server.");
        });
    }

    update_password(userName.value, passwordInput.value) ;


    });

    /**
     * Returns user to the login screen after successful reset
     */
    function loginBtn() {
    resetSuccessDiv.style.display = "none";
    signInContainer.style.display = "flex";
    }

    // ========== 🚀 Init on Page Load ==========
    renderRules(); // Show rules on load
    passwordInput.addEventListener("input", () => updateStrengthDisplay(passwordInput.value));













    //////////////////////////////////////
    // USER REGISTRATION MODULE
    //////////////////////////////////////

    // === Element References ===
    const nameInput = document.getElementById("name");
    const usernameInput = document.getElementById("usersNameRegister");
    const usernameStatus = document.getElementById("usernameStatus");
    const registerBtn = document.getElementById("registerBtn");
    const toggleRegisterPassword = document.getElementById("toggleRegisterPassword");
    const showRegisterPass = document.getElementById("showRegisterPass");
    const hideRegisterPass = document.getElementById("hideRegisterPass");
    const registerPassword = document.getElementById("registerPassword");
    const passwordStrengthDiv = document.getElementById("signupPasswordResetStrengthVerification");
    const phoneInput = document.getElementById("textFieldPhone");
    const phoneStatus = document.getElementById("phoneError");
    const username_pass = document.getElementById("username_pass");
    const phoneNumberPass = document.getElementById("phoneNumberPass");

    // === Validation Flags ===
    let isUsernameValid = false;
    let isPasswordStrong = false;
    let isPhoneValid = false;

    // === Simulated Existing Usernames (for demo) ===
    let existingUsernames = [];

    // This fetch API is to preload all users names from the db and store then in the let variable existingUsernames = [];
    async function getAllUsernames() {
    try {
        const res = await fetch('http://localhost/rise-sms/api/v_1/register/get_usernames');
        const data = await res.json();

        if (data.success) {
        // console.log("✅ Usernames loaded:", existingUsernames);
        existingUsernames = data.usernames.map(u => u.toLowerCase()); // Normalize to lowercase
        } else {
        throw new Error("Could not fetch usernames");
        }

    } catch (error) {
        // console.error("❌ Failed to fetch usernames:", error);
        return [];
    }
    }

    //  THIS IS AULOAD THE USERNAMES ALREADY FOR EASY VALIDATION
    window.addEventListener("DOMContentLoaded", () => {
    getAllUsernames(); // Preload for faster validation
    });



    //////////////////////////////////////
    // PASSWORD STRENGTH VALIDATION
    //////////////////////////////////////

    const signupPassRules = [
    { id: "lengthRule", text: "At least 8 characters", test: (pw) => pw.length >= 8 },
    { id: "upperRule", text: "At least one uppercase letter (A-Z)", test: (pw) => /[A-Z]/.test(pw) },
    { id: "lowerRule", text: "At least one lowercase letter (a-z)", test: (pw) => /[a-z]/.test(pw) },
    { id: "numberRule", text: "At least one number (0-9)", test: (pw) => /[0-9]/.test(pw) },
    { id: "specialCharRule", text: "At least one special character (!@#$%^&*)", test: (pw) => /[!@#\$%\^&\*]/.test(pw) }
    ];

    // Show/Hide password strength div
    function toggleStrengthDiv() {
    passwordStrengthDiv.style.display = (document.activeElement === registerPassword || registerPassword.value.trim().length > 0)
        ? "block"
        : "none";
    }
    registerPassword.addEventListener("focus", toggleStrengthDiv);
    registerPassword.addEventListener("input", toggleStrengthDiv);
    registerPassword.addEventListener("blur", () => {
    if (registerPassword.value.trim().length === 0) passwordStrengthDiv.style.display = "none";
    });

    // Render password rules
    function renderRulesRegister() {
    passwordStrengthDiv.innerHTML = "";
    signupPassRules.forEach(rule => {
        const div = document.createElement("div");
        div.id = rule.id;
        div.innerHTML = `❌ ${rule.text}`;
        div.style.color = "#8a8a8a";
        passwordStrengthDiv.appendChild(div);
    });
    }

    // Update rules as user types
    function updateRegisterStrengthDisplay(password) {
    let allPassed = true;

    signupPassRules.forEach(rule => {
        const ruleDiv = document.getElementById(rule.id);
        const passed = rule.test(password);
        ruleDiv.innerHTML = `${passed ? '✅' : '❌'} ${rule.text}`;
        ruleDiv.style.color = passed ? "green" : "#8a8a8a";
        if (!passed) allPassed = false;
    });

    isPasswordStrong = allPassed;
    validateAllFields();
    }

    renderRulesRegister();

    registerPassword.addEventListener("input", () => {
    updateRegisterStrengthDisplay(registerPassword.value);
    });

    // Toggle password visibility
    toggleRegisterPassword.addEventListener("click", () => {
    const isPassword = registerPassword.getAttribute("type") === "password";
    registerPassword.setAttribute("type", isPassword ? "text" : "password");
    showRegisterPass.style.display = isPassword ? "none" : "inline";
    hideRegisterPass.style.display = isPassword ? "inline" : "none";
    });

    //////////////////////////////////////
    // USERNAME VALIDATION
    //////////////////////////////////////

    async function checkUsernameAvailability(username) {
    await new Promise(resolve => setTimeout(resolve, 300)); // Simulate delay
    return !existingUsernames.includes(username.toLowerCase());
    }

    async function suggestAndSetUsername(name) {
    const base = name.trim().toLowerCase().replace(/\s+/g, "_").replace(/[^a-z0-9_]/g, "");
    let username = base;
    let suffix = 1;

    while (!(await checkUsernameAvailability(username))) {
        username = `${base}_${suffix++}`;
    }

    usernameInput.value = username;
    validateUsername(username);
    }

    async function validateUsername(username) {
    const available = await checkUsernameAvailability(username);

    if (username.length < 3) {
        usernameStatus.innerText = "Username too short.";
        usernameStatus.style.color = "red";
        username_pass.style.display = "none";
        isUsernameValid = false;
    } else if (!available) {
        usernameStatus.innerText = "Username already taken.";
        usernameStatus.style.color = "red";
        username_pass.style.display = "none";
        isUsernameValid = false;
    } else {
        usernameStatus.innerText = "";
        usernameInput.style.borderColor = "green";
        username_pass.style.display = "block";
        isUsernameValid = true;
    }

    validateAllFields();
    }

    nameInput.addEventListener("input", () => {
    const name = nameInput.value.trim();
    if (name.length > 2) {
        suggestAndSetUsername(name);
    } else {
        usernameInput.value = "";
        usernameStatus.innerText = "";
        isUsernameValid = false;
        validateAllFields();
    }
    });

    usernameInput.addEventListener("input", () => {
    validateUsername(usernameInput.value.trim().toLowerCase());
    });

    //////////////////////////////////////
    // PHONE NUMBER VALIDATION
    //////////////////////////////////////

    function isValidCameroonPhone(phone) {
    return /^6[5-9][0-9]{7}$/.test(phone);
    }

    async function checkPhoneNumberInDB(fullNumber) {
    try {
        const response = await fetch('http://localhost/rise-sms/api/v_1/register/check_phone?phone=' + encodeURIComponent(fullNumber));
        const data = await response.json();
        return data.available === true;
    } catch (error) {
        // console.error("Phone check error:", error);
        return false;
    }
    }

    phoneInput.addEventListener("input", async () => {
    const raw = phoneInput.value.replace(/\D/g, '').slice(0, 9);
    phoneInput.value = raw;

    const fullPhone = raw;

    if (!isValidCameroonPhone(raw)) {
        phoneStatus.innerText = "Enter a valid Cameroon mobile number (format: 6xxxxxxxx)";
        phoneStatus.style.color = "red";
        phoneInput.style.borderColor = "red";
        phoneNumberPass.style.display = "none";
        isPhoneValid = false;
        validateAllFields();
        return;
    }

    const isAvailable = await checkPhoneNumberInDB(fullPhone);

    if (isAvailable) {
        phoneStatus.innerText = "";
        phoneStatus.style.color = "green";
        phoneNumberPass.style.display = "block";
        phoneInput.style.borderColor = "green";
        isPhoneValid = true;
    } else {
        phoneStatus.innerText = "Phone number is already registered ❌";
        phoneStatus.style.color = "red";
        phoneInput.style.borderColor = "red";
        phoneNumberPass.style.display = "none";
        isPhoneValid = false;
    }

    validateAllFields();
    });

    //////////////////////////////////////
    // FINAL VALIDATION + SUBMISSION
    //////////////////////////////////////

    function validateAllFields() {
    const checkboxChecked = document.getElementById("termsCheckbox").checked; //Validating terms and condition
    const allPassed = isUsernameValid && isPasswordStrong && isPhoneValid && checkboxChecked;;

    registerBtn.disabled = !allPassed;
    registerBtn.style.backgroundColor = allPassed ? "#c1ff72" : "#ccc";
    registerBtn.style.cursor = allPassed ? "pointer" : "not-allowed";
    }

    document.getElementById("termsCheckbox").addEventListener("change", validateAllFields);

    // Default button state
    registerBtn.disabled = true;
    registerBtn.style.backgroundColor = "#ccc";
    registerBtn.style.cursor = "not-allowed";

    // === FORM SUBMISSION FUNCTION ===
    function handleRegistration() {
    const name = nameInput.value.trim();
    const username = usernameInput.value.trim();
    const phone = phoneInput.value.trim();
    const password = registerPassword.value;

    const data = { name, username, phone, password };
    // console.log("✅ Registration data submitted:", data);

    // Show the loading modal
    document.getElementById("loadingModal").style.display = "flex";

    // Generate a random 6-digit OTP
    const generatedOTP = Math.floor(100000 + Math.random() * 900000).toString();
    sessionStorage.setItem("otp_code", generatedOTP); // Store temporarily for verification

    // Send OTP via your SMS API
    const message = encodeURIComponent(`Your OTP code is "${generatedOTP}". Do not share with anyone`);
    const main_username = "samayanick0074@gmail.com"; // replace with actual
    const main_password = "ohipopo2024"; // replace with actual
    const senderId = "Ohipopo"; // optional: depends on your account setup
    const smsAPI = `https://smsvas.com/bulk/public/index.php/api/v1/sendsms?user=${main_username}&password=${main_password}&senderid=${senderId}&sms=${message}&mobiles=${phone}`;

    fetch(smsAPI)
        .then(res => res.json())
        .then(result => {
        // console.log("📨 OTP sent:", result);

        // Hide loading modal now
        document.getElementById("loadingModal").style.display = "none";

        // Show the OTP verification screen
        document.getElementById("signupContainer").style.display = "none";
        document.getElementById("numberOtpSendTo").innerHTML = phone ;
        document.getElementById("phoneVerification").style.display = "flex";

        let countdown = 59;
        const resendBtn = document.getElementById("resendVerificationOTP");
        const timerSpan = document.getElementById("secLeftToSendVerificationOTP");
        resendBtn.style.display = "none";

        function startOTPTimer() {
            countdown = 59;
            resendBtn.style.display = "none";
            timerSpan.textContent = countdown;
            const timer = setInterval(() => {
            countdown--;
            timerSpan.textContent = countdown;
            if (countdown <= 0) {
                clearInterval(timer);
                resendBtn.style.display = "inline-block";
                timerSpan.textContent = "0";
            }
            }, 1000);
        }

        startOTPTimer();

        // Allow OTP resend
        resendBtn.onclick = () => {
            handleRegistration(); // Resend triggers the whole function again
        };

        // OTP verification
        const otpInputs = document.querySelectorAll(".otp-input-registration");
        const otpContainer = document.getElementById("otpSubmitContainer");

        otpInputs.forEach((input, index) => {
            input.addEventListener("input", () => {
            input.value = input.value.replace(/\D/g, "").slice(0, 1); // Allow only 1 digit
            if (input.value && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
            checkFullOTP();
            });
        });

        function checkFullOTP() {
            const enteredRegistrationOTP = Array.from(otpInputs).map(input => input.value).join("");
            if (enteredRegistrationOTP.length === 6) {
            if (enteredRegistrationOTP === sessionStorage.getItem("otp_code")) {
                //alert("✅ Phone verified successfully!");
                submitToBackend(data); // Submit final registration
            } else {
                alert("❌ Incorrect OTP. Please try again.");
                otpInputs.forEach(input => (input.value = ""));
                otpInputs[0].focus();
                startOTPTimer(); // Restart countdown
            }
            }
        }

        })
        .catch(err => {
        // console.error("❌ Error sending OTP:", err);
        alert("Failed to send OTP. Please try again.");
        });
    }

    // Final submission function (adjust URL/API as needed)
    function submitToBackend(data) {
    fetch('http://localhost/rise-sms/api/v_1/register/basic_info', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(data)
    })
        .then(async res => {
        const text = await res.text();
        try {
            const json = JSON.parse(text);
            // console.log("✅ Registration successful:", json);
            loginNow(); // CALL THE NOW LOGIN FUNCTION TO ALLOOW USERS LOG INTO THEIR ACCOUNT
        } catch (e) {
            // console.error("❌ Server returned non-JSON (maybe PHP error):", text);
            // alert("Server error: Please check your backend logs.");
        }
        })
        .catch(err => {
        // console.error("❌ Submission error:", err);
        // alert("Failed to contact server.");
        });

    }


    // === Trigger form submission on click ===
    registerBtn.addEventListener("click", function(e) {
    e.preventDefault(); // Prevent default form submission (e.g., page reload)
    handleRegistration(); // Call your custom registration function
    });


    // THIS IS THE FUNCTION THATS RUNS AFTER USER HAS SUCCESSFULLY REGISTERED
    function loginNow(){
    const width = window.innerWidth;
    if(width <= 480){
        // Automatically click the login instead button because its a smaller device
        signinInstead.click();
        showToast() // display registration successful toast
    } else {
        // Automatically click the login button because its a larger device
        signInButton.click();
        showToast() // display registration successful toast
    }

    }

    function showToast(duration = 4000) {
    const toast = document.getElementById("toast");
    toast.classList.add("show");

    setTimeout(() => {
        toast.classList.remove("show");
    }, duration);
    }


