      /* ============================================================================
          GLOBAL VARIABLES & DOM ELEMENTS
      ============================================================================ */

      const messageInput = document.getElementById("messageBody");
      const charCountDisplay = document.getElementById("charCount");
      const smsPartsDisplay = document.getElementById("smsParts");
      const username          = sessionStorage.getItem("username");

      /* ============================================================================
          1. INITIAL USER DATA FETCH
      ============================================================================ */
      fetch(`http://localhost/rise-sms/api/v_1/user/get_user_details?username=${encodeURIComponent(username)}`, {
        method: 'GET',
        headers: { 'Authorization': username }
      })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            displayUserDetails(data.user);
          }
        })
        .catch(err => console.error("❌ User data fetch error:", err));

      /**
       * Display main user details on UI.
       */
      function displayUserDetails(user) {
        const firstName = user.name.split(" ")[0];
        document.getElementById("customer_name").innerText      = firstName;

      }

      function openLoader() {
        document.getElementById('loaderGIF').style.display = 'flex';
      }
      
      function closeLoader() {
          document.getElementById('loaderGIF').style.display = 'none';
      }


      let buffer = ""; // to store comma-separated phone numbers
      let phoneNumbers = [];

      


      document.addEventListener("DOMContentLoaded", async () => {
        const params = new URLSearchParams(window.location.search);
        const messageId = params.get('id');
        document.getElementById('messageId').value = messageId;
      
        if (!messageId) return;
      
        try {
          const res = await fetch(`http://localhost/rise-sms/api/v_1/sms/get_single_sms?id=${messageId}`);
          const data = await res.json();
      
          if (data.success) {
            const msg = data.message;
            
            // Split recipients and display as tags
            msg.recipients.split(",").forEach(phone => {
              const cleaned = phone.trim();
              if (cleaned) {
                phoneNumbers.push(cleaned);      // ✅ Add to array used in update
                createPhoneTag(cleaned);         // ✅ Create tag for UI
              }
            });
            
      
            // Prefill the form
            document.getElementById("loginUserId").value = msg.user_id;
            document.getElementById("messageBody").value = msg.message;
            document.getElementById("scheduleMessage").value = msg.schedule_time;
            document.getElementById("queueId").value = msg.id;


            // ✅ Load sender IDs and preselect the correct one
            loadSenderIDs(msg.sender_id);

          } else {
            alert("Failed to load message details.");
          }
        } catch (err) {
          console.error("Fetch failed:", err);
          alert("An error occurred loading the message.");
        }
      });


      
      const receipiantInput = document.getElementById('receipiant');
      const ptags = document.getElementById('phoneTags');
      const receipiantGroup = receipiantInput.parentElement; // To insert tags into same visual block
      
      // Create a container for tags inside the input wrapper
      const tagContainer = document.createElement('div');
      tagContainer.className = 'tag-container';
      tagContainer.style.display = 'flex';
      tagContainer.style.flexWrap = 'wrap';
      tagContainer.style.alignItems = 'center';
      receipiantGroup.insertBefore(tagContainer, ptags);
      
      // Typing logic
      receipiantInput.addEventListener('input', (e) => {
        let input = e.target.value;
        let digits = input.replace(/\D/g, '');
      
        // Keep looping while we have at least one 9-digit number
        while (digits.length >= 9) {
          const phone = digits.slice(0, 9);
      
          if (!phoneNumbers.includes(phone)) {
            buffer += phone + ",";
            phoneNumbers.push(phone);
            createPhoneTag(phone);
          }
      
          digits = digits.slice(9); // <-- Correct: reduce digits for next loop
        }
      
        // Show leftover digits (incomplete phone number) back in the input
        e.target.value = digits;
      });
      

      function createPhoneTag(phone) {
        const tagContainer = document.getElementById('phoneTags');
      
        const tag = document.createElement('span');
        tag.classList.add('phone-tag');
        tag.textContent = phone;
      
        // Add close (x) icon
        const removeBtn = document.createElement('span');
        removeBtn.classList.add('remove-tag');
        removeBtn.innerHTML = '&times;';
        removeBtn.onclick = function () {
          tagContainer.removeChild(tag);
          // Remove from phoneNumbers array
          phoneNumbers = phoneNumbers.filter(num => num !== phone);
          buffer = buffer.replace(phone + ',', '');
        };
      
        tag.appendChild(removeBtn);
        tagContainer.appendChild(tag);

        
      }

      messageInput.addEventListener("input", function () {
        const charCount = messageInput.value.length;
        const parts = Math.ceil(charCount / 150) || 1;

        charCountDisplay.textContent = charCount;
        smsPartsDisplay.textContent = parts;
      });
      

      function loadSenderIDs(selectedId = null) {
        fetch("http://localhost/rise-sms/api/v_1/sms/get_sender_ids", {
          method: 'GET',
          credentials: 'include' // in case you're using sessions
        })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            const select = document.getElementById("senderId");
            select.innerHTML = ""; // Clear existing
      
            data.senders.forEach(sid => {
              const option = document.createElement("option");
              option.value = sid.id;
              option.textContent = sid.sender_id;
      
              // Preselect the sender ID if it matches
              if (selectedId && selectedId == sid.id) {
                option.selected = true;
              }
      
              select.appendChild(option);
            });
      
          } else {
            console.error("⚠️ Could not fetch sender IDs:", data.message);
          }
        })
        .catch(err => {
          console.error("❌ Sender ID load error:", err);
        });
      }
      



      async function updateMessage() {
        const id = document.getElementById("messageId").value;
        const senderId = document.getElementById("senderId").value;
        const message = document.getElementById("messageBody").value;
        const schedule = document.getElementById("scheduleMessage").value;

        const recipients = phoneNumbers.join(","); // phoneTags is an array created from tags
      
        const payload = {
          id, senderId, message, schedule, recipients
        };
      
        try {
          const res = await fetch('http://localhost/rise-sms/api/v_1/sms/update_sms', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(payload)
          });
      
          const data = await res.json();
          if (data.success) {
            alert("✅ Message updated!");
            window.location.href = "send_sms"; // or wherever your list is
          } else {
            alert("❌ Update failed: " + data.error);
          }
        } catch (err) {
          console.error(err);
          alert("❌ Network or server error.");
        }
      }
      

     